// BrightLSLdemo.lsl - Copyright (C) 2011, Shan Bright - brightcorporation.net

/* BrightLSL is an LSL configuration file for the free editor Notepad++.
This LSL script does nothing except briefly document & demonstrate its use.

INSTRUCTIONS
To edit LSL scripts on your own PC...
1. Visit notepad-plus-plus.org and download Notepad++.
2. Visit brightcorporation.com/brightlsl to download Bright LSL.
3. Run Notepad++, "View">"User-Defined Dialogue...".
4. Click "Import..." & select "BrightLSL 1.3.xml".
5. Select "File">"Save As...", and save as "myscript.lsl".
6. Write your LSL script!

NOTES
"Language">"BrightLSL 1.3" uses BrightLSL before saving.
To open from Explorer, right-click & "Edit with Notepad++".

FEATURES
Recognises "{" & "}" to allow Notepad++ to 'fold' code.
Colour coding...
BLACK: background
WHITE: comments, operators & symbols, like +, {...}, & =
GREEN: user-defined names, like function & variable names.
RED: 'keywords': types like string & statements like return
CYAN: event names, like state_entry & touch_start
BLUE: library functions, like llSay() & llRound()
PURPLE: library constants, like TRUE & DEBUG_CHANNEL
YELLOW: literals, like 123.4 & "this is a string"

VERSION
BrightLSL 1.3 reflects LSL as defined as of 25th August 2011 at wiki.secondlife.com/wiki/LSL_Portal, including...
events: .../wiki/Category:LSL_Events
functions: .../wiki/Category:LSL_Functions
constants: .../wiki/Category:LSL_Constants
operators: .../wiki/Category:LSL_Operators */

default
{
    state_entry()
    {
        string thing_to_say = "Welcome to BrightLSL!";
        llSay(PUBLIC_CHANNEL, thing_to_say);
    }
}
